import { OpenAPI, AppointmentSearchService, AppointmentSearchResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listAppointmentSearches(): Promise<ApiListResponse<AppointmentSearchResponse>> {
  const response = await AppointmentSearchService.appointmentSearchList({
    page: 1,
    pageSize: 10,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<AppointmentSearchResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} appointmentsearches (total: ${meta.total_count})`);
  return response;
}
