import { OpenAPI, AppointmentService, AppointmentResponse, AppointmentRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createAppointment(
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  serviceId: string,
  bookingId: string
): Promise<AppointmentResponse> {
  const startsAt = new Date(Date.now() + 24 * 60 * 60 * 1000); // Tomorrow
  const endsAt = new Date(startsAt.getTime() + 60 * 60 * 1000); // +1 hour

  const response = await AppointmentService.appointmentCreate({
    requestBody: {
      status: AppointmentRequest.status.PENDING,
      starts_at: startsAt.toISOString(),
      ends_at: endsAt.toISOString(),
      notes: 'Client requested afternoon slot',
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      service_id: serviceId,
      booking_id: bookingId
    }
  }) as unknown as ApiDataResponse<AppointmentResponse>;

  const appointment = extractData(response);
  console.log(`Created appointment: ${appointment.id} at ${appointment.starts_at}`);
  return appointment;
}
