import { OpenAPI, AppointmentService, AppointmentResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listAppointments(): Promise<ApiListResponse<AppointmentResponse>> {
  const response = await AppointmentService.appointmentList({
    page: 1,
    pageSize: 10,
    orderBy: 'starts_at',
  }) as unknown as ApiListResponse<AppointmentResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} appointments (total: ${meta.total_count})`);
  data.forEach((appointment) => {
    console.log(`- ${appointment.id} at ${appointment.starts_at} (${appointment.status})`);
  });
  return response;
}
