import { OpenAPI, AppointmentService, AppointmentResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getAppointment(appointmentId: string): Promise<AppointmentResponse> {
  const response = await AppointmentService.appointmentGet({ id: appointmentId }) as unknown as ApiDataResponse<AppointmentResponse>;

  const appointment = extractData(response);

  console.log(`Appointment: ${appointment.id}`);
  console.log(`Status: ${appointment.status}`);
  console.log(`Starts: ${appointment.starts_at}`);
  console.log(`Ends: ${appointment.ends_at}`);
  return appointment;
}
