import { OpenAPI, AvailabilityService, AvailabilityResponse, AvailabilityRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createAvailability(
  tenantId: string,
  merchantId: string,
  serviceId: string,
  providerId?: string,
  locationId?: string
): Promise<AvailabilityResponse> {
  const startAt = new Date(Date.now() + 24 * 60 * 60 * 1000); // Tomorrow

  const response = await AvailabilityService.availabilityCreate({
    requestBody: {
      status: AvailabilityRequest.status.OPEN,
      start_at: startAt.toISOString(),
      duration_minutes: 60,
      tenant_id: tenantId,
      merchant_id: merchantId,
      service_id: serviceId,
      provider_id: providerId,
      location_id: locationId
    }
  }) as unknown as ApiDataResponse<AvailabilityResponse>;

  const availability = extractData(response);
  console.log(`Created availability: ${availability.id} at ${availability.start_at}`);
  return availability;
}
