import { OpenAPI, BookingEnquiryService, BookingEnquiryResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listBookingEnquiries(
  page: number = 1,
  pageSize: number = 10
): Promise<ApiListResponse<BookingEnquiryResponse>> {
  const response = await BookingEnquiryService.bookingEnquiryList({
    page,
    pageSize,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<BookingEnquiryResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} booking enquiries (total: ${meta.total_count})`);
  return response;
}
