import { OpenAPI, BookingPolicyService, BookingPolicyResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listBookingPolicies(): Promise<ApiListResponse<BookingPolicyResponse>> {
  const response = await BookingPolicyService.bookingPolicyList({
    page: 1,
    pageSize: 10,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<BookingPolicyResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} bookingpolicies (total: ${meta.total_count})`);
  return response;
}
