import { OpenAPI, BookingPolicyService, BookingPolicyResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getBookingPolicy(booking_policyId: string): Promise<BookingPolicyResponse> {
  const response = await BookingPolicyService.bookingPolicyGet({ id: booking_policyId }) as unknown as ApiDataResponse<BookingPolicyResponse>;

  const booking_policy = extractData(response);

  console.log(`BookingPolicy: ${booking_policy.name || booking_policy.id}`);
  return booking_policy;
}
