import { OpenAPI, BookingPolicyService, BookingPolicyResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateBookingPolicy(booking_policyId: string, tenantId: string, merchantId: string): Promise<BookingPolicyResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await BookingPolicyService.bookingPolicyUpdate({
    id: booking_policyId,
    requestBody: {
      name: `Updated BookingPolicy ${uniqueId}`,
      policy_type: 'book_appointment' as any,
      effect: 'allow' as any,
      priority: 'important' as any,
      min_age: 18,
      customer_statuses: ['established'],
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<BookingPolicyResponse>;

  const booking_policy = extractData(response);
  console.log(`Updated booking_policy: ${booking_policy.name || booking_policy.id}`);
  return booking_policy;
}
