import { OpenAPI, BookingService, BookingResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getBooking(id: string): Promise<BookingResponse> {
  const response = await BookingService.bookingGet({ id }) as unknown as ApiDataResponse<BookingResponse>;
  const booking = extractData(response);
  console.log(`Retrieved booking: ${booking.id} (status: ${booking.status})`);
  return booking;
}
