import { OpenAPI, BookingService, BookingResponse, BookingRequest } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateBooking(
  id: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string
): Promise<BookingResponse> {
  const response = await BookingService.bookingUpdate({
    id,
    requestBody: {
      status: BookingRequest.status.CONFIRMED,
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId
    }
  }) as unknown as ApiDataResponse<BookingResponse>;

  const booking = extractData(response);
  console.log(`Updated booking: ${booking.id} (status: ${booking.status})`);
  return booking;
}
