import { OpenAPI, EndCustomerSearchService, EndCustomerSearchResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getEndCustomerSearch(end_customer_searchId: string): Promise<EndCustomerSearchResponse> {
  const response = await EndCustomerSearchService.endCustomerSearchGet({ id: end_customer_searchId }) as unknown as ApiDataResponse<EndCustomerSearchResponse>;

  const end_customer_search = extractData(response);

  console.log(`EndCustomerSearch: ${end_customer_search.name || end_customer_search.id}`);
  return end_customer_search;
}
