import { OpenAPI, EndCustomerSearchService, EndCustomerSearchResponse, EndCustomerSearchRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateEndCustomerSearch(end_customer_searchId: string, tenantId: string, merchantId: string, userId?: string): Promise<EndCustomerSearchResponse> {
  const response = await EndCustomerSearchService.endCustomerSearchUpdate({
    id: end_customer_searchId,
    requestBody: {
      tenant_id: tenantId,
      merchant_id: merchantId,
      user_id: userId || uuidv4(),
      end_customer_type: 'business',
      first_name: 'Updated',
    }
  }) as unknown as ApiDataResponse<EndCustomerSearchResponse>;

  const end_customer_search = extractData(response);
  console.log(`Updated end_customer_search: ${end_customer_search.id}`);
  return end_customer_search;
}
