import { OpenAPI, EndCustomerService, EndCustomerResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getEndCustomer(customerId: string): Promise<EndCustomerResponse> {
  const response = await EndCustomerService.endCustomerGet({ id: customerId }) as unknown as ApiDataResponse<EndCustomerResponse>;

  const customer = extractData(response);

  console.log(`Customer: ${customer.first_name} ${customer.last_name}`);
  console.log(`Email: ${customer.email || '(none)'}`);
  console.log(`Phone: ${customer.phone || '(none)'}`);
  return customer;
}
