import { OpenAPI, EndCustomerService, EndCustomerResponse, EndCustomerRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateEndCustomer(customerId: string, tenantId: string, merchantId: string): Promise<EndCustomerResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await EndCustomerService.endCustomerUpdate({
    id: customerId,
    requestBody: {
      first_name: `Jane_${uniqueId}`,
      last_name: `Smith_${uniqueId}`,
      email: `jane.smith.${uniqueId}@example.com`,
      type: EndCustomerRequest.type.PERSONAL,
      tenant_id: tenantId,
      merchant_id: merchantId
    }
  }) as unknown as ApiDataResponse<EndCustomerResponse>;

  const customer = extractData(response);
  console.log(`Updated customer: ${customer.first_name} ${customer.last_name}`);
  return customer;
}
