import { OpenAPI, FormResponseService, FormResponseResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listFormResponses(
  page = 1,
  pageSize = 20
): Promise<ApiListResponse<FormResponseResponse>> {
  const response = await FormResponseService.formResponseList({
    page,
    pageSize,
    orderBy: 'submission_date'
  }) as unknown as ApiListResponse<FormResponseResponse>;

  console.log(`Retrieved ${response.data?.length || 0} form responses (page ${page})`);
  return response;
}
