import { OpenAPI, FormResponseService, FormResponseResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateFormResponse(
  id: string,
  tenantId: string,
  merchantId: string,
  endCustomerId: string
): Promise<FormResponseResponse> {
  const response = await FormResponseService.formResponseUpdate({
    id,
    requestBody: {
      name: 'Updated Patient Intake Form',
      form_type: 'intake',
      submission_date: new Date().toISOString(),
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId
    }
  }) as unknown as ApiDataResponse<FormResponseResponse>;

  const formResponse = extractData(response);
  console.log(`Updated form response: ${formResponse.name} (${formResponse.id})`);
  return formResponse;
}
