import { OpenAPI, LocationService, LocationResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createLocation(tenantId: string, merchantId: string): Promise<LocationResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await LocationService.locationCreate({
    requestBody: {
      name: `Main Location ${uniqueId}`,
      address_line1: `123 Main St ${uniqueId}`,
      city: 'San Francisco',
      state: 'CA',
      postal_code: '94102',
      country: 'US',
      phone: '+14155551234',
      tenant_id: tenantId,
      merchant_id: merchantId
    }
  }) as unknown as ApiDataResponse<LocationResponse>;

  const location = extractData(response);
  console.log(`Created location: ${location.name} (${location.id})`);
  return location;
}
