import { OpenAPI, LocationService, LocationResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listLocations(): Promise<ApiListResponse<LocationResponse>> {
  const response = await LocationService.locationList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<LocationResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} locations (total: ${meta.total_count})`);
  data.forEach((location) => {
    console.log(`- ${location.name} (${location.city}, ${location.state})`);
  });
  return response;
}
