import { OpenAPI, LocationService, LocationResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getLocation(locationId: string): Promise<LocationResponse> {
  const response = await LocationService.locationGet({ id: locationId }) as unknown as ApiDataResponse<LocationResponse>;

  const location = extractData(response);

  console.log(`Location: ${location.name}`);
  console.log(`Address: ${location.address_line1}, ${location.city}, ${location.state}`);
  console.log(`Phone: ${location.phone || '(none)'}`);
  return location;
}
