import { OpenAPI, MerchantOrgService, MerchantOrgResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Create a new merchant organization
 */
export async function createMerchantOrg(tenantId: string): Promise<MerchantOrgResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await MerchantOrgService.merchantOrgCreate({
    requestBody: {
      name: `Acme Corp ${uniqueId}`,
      legal_name: `Acme Corporation ${uniqueId}`,
      email: `info-${uniqueId}@acmecorp.example.com`,
      phone: '+1234567890',
      tenant_id: tenantId,
      status: MerchantOrgResponse.status.ACTIVE
    }
  }) as unknown as ApiDataResponse<MerchantOrgResponse>;

  // API returns {data: {...}}, extract the actual merchant org
  const merchantOrg = extractData(response);
  console.log(`Created merchant org: ${merchantOrg.name} (${merchantOrg.id})`);
  return merchantOrg;
}
