import { OpenAPI, MerchantOrgService, MerchantOrgResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * List merchant organizations with pagination
 */
export async function listMerchantOrgs(): Promise<ApiListResponse<MerchantOrgResponse>> {
  const response = await MerchantOrgService.merchantOrgList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<MerchantOrgResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} merchant orgs (total: ${meta.total_count})`);
  data.forEach((merchantOrg) => {
    console.log(`- ${merchantOrg.name} (${merchantOrg.status})`);
  });
  return response;
}
