import { OpenAPI, MerchantService, MerchantResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Get a single merchant by ID
 */
export async function getMerchant(merchantId: string): Promise<MerchantResponse> {
  const response = await MerchantService.merchantGet({ id: merchantId }) as unknown as ApiDataResponse<MerchantResponse>;

  const merchant = extractData(response);

  console.log(`Merchant: ${merchant.name}`);
  console.log(`Public Name: ${merchant.public_name}`);
  console.log(`Merchant Org ID: ${merchant.merchant_org_id}`);
  return merchant;
}
