import { OpenAPI, MessageService, MessageResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getMessage(id: string): Promise<MessageResponse> {
  const response = await MessageService.messageGet({
    id
  }) as unknown as ApiDataResponse<MessageResponse>;

  const message = extractData(response);
  console.log(`Retrieved message: ${message.id}`);
  return message;
}
