import { OpenAPI, PaymentAccountService, PaymentAccountResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createPaymentAccount(
  tenantId: string,
  merchantId: string,
  endCustomerId: string,
  pluginId: string
): Promise<PaymentAccountResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await PaymentAccountService.paymentAccountCreate({
    requestBody: {
      type: 'card' as any,
      status: 'active' as any,
      external_id: `pm_test_${uniqueId}`,
      last_4: '4242',
      brand: 'visa',
      exp_month: 12,
      exp_year: 2026,
      is_default: false,
      tenant_id: tenantId,
      merchant_id: merchantId,
      end_customer_id: endCustomerId,
      plugin_id: pluginId,
    }
  }) as unknown as ApiDataResponse<PaymentAccountResponse>;

  const payment_account = extractData(response);
  console.log(`Created payment account: ${payment_account.brand} *${payment_account.last_4} (${payment_account.id})`);
  return payment_account;
}
