import { OpenAPI, PaymentAccountService, PaymentAccountResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listPaymentAccounts(): Promise<ApiListResponse<PaymentAccountResponse>> {
  const response = await PaymentAccountService.paymentAccountList({
    page: 1,
    pageSize: 10,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<PaymentAccountResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} payment accounts (total: ${meta.total_count})`);
  return response;
}
