import { OpenAPI, PaymentContractService, PaymentContractResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createPaymentContract(
  tenantId: string,
  merchantId: string,
  bookingId: string,
  endCustomerId: string
): Promise<PaymentContractResponse> {
  const response = await PaymentContractService.paymentContractCreate({
    requestBody: {
      amount: { amount: 5000, currency: 'usd' },
      contract_type: 'deposit' as any,
      status: 'pending' as any,
      booking_id: bookingId,
      end_customer_id: endCustomerId,
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<PaymentContractResponse>;

  const payment_contract = extractData(response);
  console.log(`Created payment_contract: ${payment_contract.contract_type} - $${(payment_contract.amount?.amount || 0) / 100} (${payment_contract.id})`);
  return payment_contract;
}
