import { OpenAPI, PaymentContractService, PaymentContractResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getPaymentContract(payment_contractId: string): Promise<PaymentContractResponse> {
  const response = await PaymentContractService.paymentContractGet({ id: payment_contractId }) as unknown as ApiDataResponse<PaymentContractResponse>;

  const payment_contract = extractData(response);

  console.log(`PaymentContract: ${payment_contract.contract_type} - $${(payment_contract.amount?.amount || 0) / 100} (${payment_contract.id})`);
  return payment_contract;
}
