import { OpenAPI, PaymentPolicyService, PaymentPolicyResponse, PaymentPolicyRequest } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createPaymentPolicy(tenantId: string, merchantOrgId: string, merchantId: string): Promise<PaymentPolicyResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await PaymentPolicyService.paymentPolicyCreate({
    requestBody: {
      name: `Test PaymentPolicy ${uniqueId}`,
      type: 'normal' as any,
      tenant_id: tenantId,
      merchant_org_id: merchantOrgId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<PaymentPolicyResponse>;

  const payment_policy = extractData(response);
  console.log(`Created payment_policy: ${payment_policy.name || payment_policy.id} (${payment_policy.id})`);
  return payment_policy;
}
