import { OpenAPI, PaymentPolicyService, PaymentPolicyResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getPaymentPolicy(payment_policyId: string): Promise<PaymentPolicyResponse> {
  const response = await PaymentPolicyService.paymentPolicyGet({ id: payment_policyId }) as unknown as ApiDataResponse<PaymentPolicyResponse>;

  const payment_policy = extractData(response);

  console.log(`PaymentPolicy: ${payment_policy.name || payment_policy.id}`);
  return payment_policy;
}
