import { OpenAPI, ProviderService, ProviderResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createProvider(tenantId: string, merchantId: string): Promise<ProviderResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await ProviderService.providerCreate({
    requestBody: {
      name: `Dr. Smith ${uniqueId}`,
      headline: 'Licensed Stylist',
      tenant_id: tenantId,
      merchant_id: merchantId
    }
  }) as unknown as ApiDataResponse<ProviderResponse>;

  const provider = extractData(response);
  console.log(`Created provider: ${provider.name} (${provider.id})`);
  return provider;
}
