import { OpenAPI, ProviderService, ProviderResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getProvider(providerId: string): Promise<ProviderResponse> {
  const response = await ProviderService.providerGet({ id: providerId }) as unknown as ApiDataResponse<ProviderResponse>;

  const provider = extractData(response);

  console.log(`Provider: ${provider.name}`);
  console.log(`Headline: ${provider.headline}`);
  return provider;
}
