import { OpenAPI, RoleService, RoleResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listRoles(): Promise<ApiListResponse<RoleResponse>> {
  const response = await RoleService.roleList({
    page: 1,
    pageSize: 10,
    orderBy: 'name'
  }) as unknown as ApiListResponse<RoleResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} roles (total: ${meta.total_count})`);
  return response;
}
