import { OpenAPI, RoleService, RoleResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getRole(roleId: string): Promise<RoleResponse> {
  const response = await RoleService.roleGet({ id: roleId }) as unknown as ApiDataResponse<RoleResponse>;

  // API returns {data: {...}}, extract the actual role
  const role = extractData(response);
  console.log(`Role: ${role.name}`);
  return role;
}
