import { OpenAPI, ServiceService, ServiceResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listServices(): Promise<ApiListResponse<ServiceResponse>> {
  const response = await ServiceService.serviceList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<ServiceResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} services (total: ${meta.total_count})`);
  data.forEach((service) => {
    console.log(`- ${service.name} (${service.duration} minutes, ${service.standard_rate_str})`);
  });
  return response;
}
