import { OpenAPI, SubscriptionService, SubscriptionResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getSubscription(subscriptionId: string): Promise<SubscriptionResponse> {
  const response = await SubscriptionService.subscriptionGet({ id: subscriptionId }) as unknown as ApiDataResponse<SubscriptionResponse>;

  const subscription = extractData(response);

  console.log(`Subscription: ${subscription.type} - ${subscription.status} (${subscription.id})`);
  return subscription;
}
