import { OpenAPI, SubscriptionService, SubscriptionResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateSubscription(subscriptionId: string, tenantId: string, merchantId: string): Promise<SubscriptionResponse> {
  const now = new Date();
  const periodEnd = new Date(now.getTime() + 365 * 24 * 60 * 60 * 1000); // 1 year from now

  const response = await SubscriptionService.subscriptionUpdate({
    id: subscriptionId,
    requestBody: {
      type: 'win_agent' as any,
      status: 'active' as any,
      billing_period: 'annual' as any,
      price: 99900,
      currency: 'usd',
      quantity: 2,
      current_period_start: now.toISOString(),
      current_period_end: periodEnd.toISOString(),
      tenant_id: tenantId,
      merchant_id: merchantId,
    }
  }) as unknown as ApiDataResponse<SubscriptionResponse>;

  const subscription = extractData(response);
  console.log(`Updated subscription: ${subscription.type} - $${(subscription.price || 0) / 100}/yr`);
  return subscription;
}
