import { OpenAPI, TenantService, TenantResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * List tenants with pagination
 */
export async function listTenants(): Promise<ApiListResponse<TenantResponse>> {
  const response = await TenantService.tenantList({
    page: 1,
    pageSize: 10,
    orderBy: 'name',
  }) as unknown as ApiListResponse<TenantResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} tenants (total: ${meta.total_count})`);
  data.forEach((tenant) => {
    console.log(`- ${tenant.name} (${tenant.type})`);
  });
  return response;
}
