import { OpenAPI, TenantService, TenantResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

/**
 * Get a single tenant by ID
 */
export async function getTenant(tenantId: string): Promise<TenantResponse> {
  const response = await TenantService.tenantGet({ id: tenantId }) as unknown as ApiDataResponse<TenantResponse>;

  // API returns {data: {...}}, extract the actual tenant
  const tenant = extractData(response);

  console.log(`Tenant: ${tenant.name}`);
  console.log(`Type: ${tenant.type}`);
  console.log(`Domain: ${tenant.domain_name || '(none)'}`);
  return tenant;
}
