import { OpenAPI, TransactionJournalService, TransactionJournalResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getTransactionJournal(id: string): Promise<TransactionJournalResponse> {
  const response = await TransactionJournalService.transactionJournalGet({
    id
  }) as unknown as ApiDataResponse<TransactionJournalResponse>;

  const transactionJournal = extractData(response);
  console.log(`Retrieved transaction journal: ${transactionJournal.id}`);
  return transactionJournal;
}
