import { OpenAPI, TransactionService, TransactionResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listTransactions(): Promise<ApiListResponse<TransactionResponse>> {
  const response = await TransactionService.transactionList({
    page: 1,
    pageSize: 10,
    orderBy: 'inserted_at',
  }) as unknown as ApiListResponse<TransactionResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} transactions (total: ${meta.total_count})`);
  return response;
}
