import { OpenAPI, TransactionService, TransactionResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getTransaction(transactionId: string): Promise<TransactionResponse> {
  const response = await TransactionService.transactionGet({ id: transactionId }) as unknown as ApiDataResponse<TransactionResponse>;

  const transaction = extractData(response);

  console.log(`Transaction: ${transaction.transaction_type} - $${(transaction.amount?.amount || 0) / 100} (${transaction.id})`);
  return transaction;
}
