import { OpenAPI, UserService, UserResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function createUser(tenantId: string): Promise<UserResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await UserService.userCreate({
    requestBody: {
      email: `user.${uniqueId}@example.com`,
      first_name: `User_${uniqueId}`,
      last_name: 'Test',
      tenant_id: tenantId
    }
  }) as unknown as ApiDataResponse<UserResponse>;

  const user = extractData(response);
  console.log(`Created user: ${user.email} (${user.id})`);
  return user;
}
