import { OpenAPI, UserService, UserResponse } from '@scp/sdk';
import { ApiListResponse } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function listUsers(): Promise<ApiListResponse<UserResponse>> {
  const response = await UserService.userList({
    page: 1,
    pageSize: 10,
    orderBy: 'email',
  }) as unknown as ApiListResponse<UserResponse>;

  const data = response.data ?? [];
  const meta = response.meta ?? { total_count: 0 };

  console.log(`Found ${data.length} users (total: ${meta.total_count})`);
  data.forEach((user) => {
    console.log(`- ${user.email} (${user.first_name} ${user.last_name})`);
  });
  return response;
}
