import { OpenAPI, UserService, UserResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function getUser(userId: string): Promise<UserResponse> {
  const response = await UserService.userGet({ id: userId }) as unknown as ApiDataResponse<UserResponse>;

  const user = extractData(response);

  console.log(`User: ${user.first_name} ${user.last_name}`);
  console.log(`Email: ${user.email}`);
  return user;
}
