import { OpenAPI, UserService, UserResponse } from '@scp/sdk';
import { v4 as uuidv4 } from 'uuid';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateUser(userId: string, tenantId: string, email: string): Promise<UserResponse> {
  const uniqueId = uuidv4().substring(0, 8);
  const response = await UserService.userUpdate({
    id: userId,
    requestBody: {
      email: email,
      first_name: `Updated_${uniqueId}`,
      last_name: 'User',
      tenant_id: tenantId
    }
  }) as unknown as ApiDataResponse<UserResponse>;

  const user = extractData(response);
  console.log(`Updated user: ${user.email}`);
  return user;
}
