import { OpenAPI, WebsiteService, WebsiteResponse } from '@scp/sdk';
import { ApiDataResponse, extractData } from '../types';

OpenAPI.BASE = OpenAPI.BASE || 'http://localhost:4000';
OpenAPI.TOKEN = OpenAPI.TOKEN || 'YOUR_API_TOKEN';

export async function updateWebsite(
  id: string,
  tenantId: string,
  merchantId: string
): Promise<WebsiteResponse> {
  const response = await WebsiteService.websiteUpdate({
    id,
    requestBody: {
      domain_name: `updated-${Date.now()}.example.com`,
      title: `Updated Website ${Date.now()}`,
      description: 'Updated website description',
      tenant_id: tenantId,
      merchant_id: merchantId,
      favicon: { url: 'https://example.com/updated-favicon.ico' },
      logo: { url: 'https://example.com/updated-logo.png' },
      login_allowed: true,
      translation_allowed: true
    }
  }) as unknown as ApiDataResponse<WebsiteResponse>;

  const website = extractData(response);
  console.log(`Updated website: ${website.domain_name}`);
  return website;
}
