import { OpenAPI } from '@scp/sdk';

/**
 * Reset the database using the sandbox endpoint
 *
 * This endpoint:
 * - Truncates the tenants table (CASCADE deletes all data)
 * - Re-seeds essential data
 * - Only available when sandbox_enabled: true in config
 *
 * @requires OpenAPI.TOKEN to be set (admin Bearer token)
 */
export async function resetDatabase(): Promise<void> {
  const response = await fetch(`${OpenAPI.BASE}/api/sandbox/reset`, {
    method: 'POST',
    headers: {
      'Authorization': `Bearer ${OpenAPI.TOKEN}`,
      'Content-Type': 'application/json',
    },
  });

  if (!response.ok) {
    const error = await response.text();
    throw new Error(`Database reset failed: ${response.status} ${error}`);
  }

  const result = await response.json();
  console.log(`✨ Database reset: ${result.message} (${result.timestamp})`);
}
